/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.fddi.eui;

import ibm.nways.fddi.model.StationModel;
import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.BooleanInput;
import ibm.nways.jdm.eui.BooleanInputRO;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.HexInput;
import ibm.nways.jdm.eui.HexInputRO;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class FddiStationPanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "Station";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel Station_model;
    protected selectionListSection selectionListPropertySection;
    protected fddimibSMTDetailSection fddimibSMTDetailPropertySection;
    protected ModelInfo FddimibSMTTableInfo;
    protected ModelInfo PanelInfo;
    protected int FddimibSMTTableIndex;
    protected FddimibSMTTable FddimibSMTTableData;
    protected TableColumns FddimibSMTTableColumns;
    protected TableStatus FddimibSMTTableStatus;
    protected static TableColumn[] FddimibSMTTableCols = new TableColumn[]{new TableColumn("Index.SmtIndex", "SMT Index", 3, true), new TableColumn("Panel.FddimibSMTStationId", "Station Identifier", 9, false), new TableColumn("Panel.FddimibSMTCFState", "CF State", 16, false), new TableColumn("Panel.FddimibSMTPeerWrapFlag", "Peer Wrap", 17, false)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.fddi.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.fddi.eui.FddiStationPanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel FddiStation");
        }
    }

    public static String getTitle() {
        FddiStationPanel.loadStatics();
        if (myResources != null) {
            title = FddiStationPanel.getNLSString("FddiStationPanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            FddiStationPanel.loadStatics();
        }
        return enumStrings;
    }

    public FddiStationPanel() {
        FddiStationPanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return FddiStationPanel.getTitle();
    }

    protected void getModels() {
        this.Station_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addselectionListSection();
        this.addfddimibSMTDetailSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addselectionListSection() {
        this.selectionListPropertySection = new selectionListSection();
        this.selectionListPropertySection.layoutSection();
        this.addSection(FddiStationPanel.getNLSString("selectionListSectionTitle"), this.selectionListPropertySection);
    }

    protected void addfddimibSMTDetailSection() {
        this.fddimibSMTDetailPropertySection = new fddimibSMTDetailSection();
        this.fddimibSMTDetailPropertySection.layoutSection();
        this.addSection(FddiStationPanel.getNLSString("fddimibSMTDetailSectionTitle"), this.fddimibSMTDetailPropertySection);
    }

    protected void panelRowChange() {
        if (this.selectionListPropertySection != null) {
            this.selectionListPropertySection.rowChange();
        }
        if (this.fddimibSMTDetailPropertySection != null) {
            this.fddimibSMTDetailPropertySection.rowChange();
        }
    }

    public void filterPanelInfos(Vector vector) {
    }

    public int getInitialFddimibSMTTableRow() {
        return 0;
    }

    public ModelInfo initialFddimibSMTTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(FddiStationPanel.getNLSString("startResetMsg"));
        this.FddimibSMTTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(FddiStationPanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(FddiStationPanel.getNLSString("endResetMsg")) + " " + FddiStationPanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.PanelInfo = new ModelInfo();
        this.PanelInfo.add("Index.SmtIndex", (Serializable)this.FddimibSMTTableData.getValueAt("Index.SmtIndex", this.FddimibSMTTableIndex));
        this.errorsFound = false;
        this.displayMsg(FddiStationPanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.FddimibSMTTableInfo = (ModelInfo)this.FddimibSMTTableData.elementAt(this.FddimibSMTTableIndex);
            this.FddimibSMTTableInfo = this.FddimibSMTTableData.setRow();
            this.FddimibSMTTableData.setElementAt(this.FddimibSMTTableInfo, this.FddimibSMTTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(FddiStationPanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(FddiStationPanel.getNLSString("endApplyMsg")) + " " + FddiStationPanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(FddiStationPanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.FddimibSMTTableData = new FddimibSMTTable();
        this.FddimibSMTTableIndex = 0;
        this.FddimibSMTTableColumns = new TableColumns(FddimibSMTTableCols);
        if (this.Station_model instanceof RemoteModelWithStatus) {
            try {
                this.FddimibSMTTableStatus = (TableStatus)this.Station_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class selectionListSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component FddimibSMTTableField;
        Label FddimibSMTTableFieldLabel;
        boolean FddimibSMTTableFieldWritable = false;

        public selectionListSection() {
            FddiStationPanel.this = FddiStationPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createFddimibSMTTableField() {
            EuiGrid euiGrid = new EuiGrid(FddiStationPanel.this.FddimibSMTTableData, FddiStationPanel.this.FddimibSMTTableColumns, true);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(FddiStationPanel.this.initialFddimibSMTTableRow());
            this.addTable(FddiStationPanel.getNLSString("FddimibSMTTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.FddimibSMTTableField = this.createFddimibSMTTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                FddiStationPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            FddiStationPanel.this.displayMsg(FddiStationPanel.getNLSString("accessDataMsg"));
            FddiStationPanel.this.displayMsg(FddiStationPanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.FddimibSMTTableField).refresh();
            FddiStationPanel.this.displayMsg(FddiStationPanel.getNLSString("endTableGetMsg"));
            FddiStationPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.FddimibSMTTableField) {
                        FddiStationPanel.this.FddimibSMTTableIndex = euiGridEvent.getRow();
                    }
                    FddiStationPanel.this.FddimibSMTTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.FddimibSMTTableField).deselectAllRows();
                    FddiStationPanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.FddimibSMTTableField) {
                        FddiStationPanel.this.FddimibSMTTableIndex = 0;
                    }
                    FddiStationPanel.this.selectionListPropertySection.reset();
                    FddiStationPanel.this.fddimibSMTDetailPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class fddimibSMTDetailSection
    extends PropertySection {
        ModelInfo chunk;
        Component fddimibSMTStationIdField;
        Component fddimibSMTUserDataField;
        Component fddimibSMTAvailablePathsField;
        Component fddimibSMTConfigCapabilitiesField;
        Component fddimibSMTConfigPolicyField;
        Component fddimibSMTMACCtsField;
        Component fddimibSMTNonMasterCtsField;
        Component fddimibSMTConnectionPolicyField;
        Component fddimibSMTTNotifyField;
        Component fddimibSMTStatRptPolicyField;
        Component fddimibSMTTraceMaxExpirationField;
        Component fddimibSMTBypassPresentField;
        Component fddimibSMTECMStateField;
        Component fddimibSMTCFStateField;
        Component fddimibSMTRemoteDisconnectFlagField;
        Component fddimibSMTStationStatusField;
        Component fddimibSMTPeerWrapFlagField;
        Component fddimibSMTStationActionField;
        Label fddimibSMTStationIdFieldLabel;
        Label fddimibSMTUserDataFieldLabel;
        Label fddimibSMTAvailablePathsFieldLabel;
        Label fddimibSMTConfigCapabilitiesFieldLabel;
        Label fddimibSMTConfigPolicyFieldLabel;
        Label fddimibSMTMACCtsFieldLabel;
        Label fddimibSMTNonMasterCtsFieldLabel;
        Label fddimibSMTConnectionPolicyFieldLabel;
        Label fddimibSMTTNotifyFieldLabel;
        Label fddimibSMTStatRptPolicyFieldLabel;
        Label fddimibSMTTraceMaxExpirationFieldLabel;
        Label fddimibSMTBypassPresentFieldLabel;
        Label fddimibSMTECMStateFieldLabel;
        Label fddimibSMTCFStateFieldLabel;
        Label fddimibSMTRemoteDisconnectFlagFieldLabel;
        Label fddimibSMTStationStatusFieldLabel;
        Label fddimibSMTPeerWrapFlagFieldLabel;
        Label fddimibSMTStationActionFieldLabel;
        boolean fddimibSMTStationIdFieldWritable = false;
        boolean fddimibSMTUserDataFieldWritable = false;
        boolean fddimibSMTAvailablePathsFieldWritable = false;
        boolean fddimibSMTConfigCapabilitiesFieldWritable = false;
        boolean fddimibSMTConfigPolicyFieldWritable = false;
        boolean fddimibSMTMACCtsFieldWritable = false;
        boolean fddimibSMTNonMasterCtsFieldWritable = false;
        boolean fddimibSMTConnectionPolicyFieldWritable = false;
        boolean fddimibSMTTNotifyFieldWritable = false;
        boolean fddimibSMTStatRptPolicyFieldWritable = false;
        boolean fddimibSMTTraceMaxExpirationFieldWritable = false;
        boolean fddimibSMTBypassPresentFieldWritable = false;
        boolean fddimibSMTECMStateFieldWritable = false;
        boolean fddimibSMTCFStateFieldWritable = false;
        boolean fddimibSMTRemoteDisconnectFlagFieldWritable = false;
        boolean fddimibSMTStationStatusFieldWritable = false;
        boolean fddimibSMTPeerWrapFlagFieldWritable = false;
        boolean fddimibSMTStationActionFieldWritable = false;

        public fddimibSMTDetailSection() {
            FddiStationPanel.this = FddiStationPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createfddimibSMTStationIdField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTStationId.access", "read-only");
            String string2 = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTStationId.length", "8");
            this.fddimibSMTStationIdFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTStationIdFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTStationIdLabel"), 2);
            if (this.fddimibSMTStationIdFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.fddimibSMTStationIdFieldLabel, (Component)hexInput);
                FddiStationPanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.fddimibSMTStationIdFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getfddimibSMTStationIdField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStationIdField);
            this.validatefddimibSMTStationIdField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTStationIdField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStationIdField);
                jDMInput.setValue(object);
                this.validatefddimibSMTStationIdField();
            }
        }

        protected boolean validatefddimibSMTStationIdField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStationIdField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTStationIdFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTStationIdFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTUserDataField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTUserData.access", "read-only");
            String string2 = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTUserData.length", "32");
            this.fddimibSMTUserDataFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTUserDataFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTUserDataLabel"), 2);
            if (this.fddimibSMTUserDataFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.fddimibSMTUserDataFieldLabel, (Component)hexInput);
                FddiStationPanel.this.containsWritableField = true;
                return hexInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.fddimibSMTUserDataFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getfddimibSMTUserDataField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTUserDataField);
            this.validatefddimibSMTUserDataField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTUserDataField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTUserDataField);
                jDMInput.setValue(object);
                this.validatefddimibSMTUserDataField();
            }
        }

        protected boolean validatefddimibSMTUserDataField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTUserDataField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTUserDataFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTUserDataFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTAvailablePathsField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTAvailablePaths.access", "read-only");
            this.fddimibSMTAvailablePathsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTAvailablePathsFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTAvailablePathsLabel"), 2);
            if (this.fddimibSMTAvailablePathsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 7);
                this.addRow(this.fddimibSMTAvailablePathsFieldLabel, (Component)numericInput);
                FddiStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.fddimibSMTAvailablePathsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getfddimibSMTAvailablePathsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTAvailablePathsField);
            this.validatefddimibSMTAvailablePathsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTAvailablePathsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTAvailablePathsField);
                jDMInput.setValue(object);
                this.validatefddimibSMTAvailablePathsField();
            }
        }

        protected boolean validatefddimibSMTAvailablePathsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTAvailablePathsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTAvailablePathsFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTAvailablePathsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTConfigCapabilitiesField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTConfigCapabilities.access", "read-only");
            this.fddimibSMTConfigCapabilitiesFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTConfigCapabilitiesFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTConfigCapabilitiesLabel"), 2);
            if (this.fddimibSMTConfigCapabilitiesFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 3);
                this.addRow(this.fddimibSMTConfigCapabilitiesFieldLabel, (Component)numericInput);
                FddiStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.fddimibSMTConfigCapabilitiesFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getfddimibSMTConfigCapabilitiesField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTConfigCapabilitiesField);
            this.validatefddimibSMTConfigCapabilitiesField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTConfigCapabilitiesField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTConfigCapabilitiesField);
                jDMInput.setValue(object);
                this.validatefddimibSMTConfigCapabilitiesField();
            }
        }

        protected boolean validatefddimibSMTConfigCapabilitiesField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTConfigCapabilitiesField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTConfigCapabilitiesFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTConfigCapabilitiesFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTConfigPolicyField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTConfigPolicy.access", "read-write");
            this.fddimibSMTConfigPolicyFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTConfigPolicyFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTConfigPolicyLabel"), 2);
            if (this.fddimibSMTConfigPolicyFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 1);
                this.addRow(this.fddimibSMTConfigPolicyFieldLabel, (Component)numericInput);
                FddiStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.fddimibSMTConfigPolicyFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getfddimibSMTConfigPolicyField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTConfigPolicyField);
            this.validatefddimibSMTConfigPolicyField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTConfigPolicyField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTConfigPolicyField);
                jDMInput.setValue(object);
                this.validatefddimibSMTConfigPolicyField();
            }
        }

        protected boolean validatefddimibSMTConfigPolicyField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTConfigPolicyField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTConfigPolicyFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTConfigPolicyFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTMACCtsField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTMACCts.access", "read-only");
            this.fddimibSMTMACCtsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTMACCtsFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTMACCtsLabel"), 2);
            if (this.fddimibSMTMACCtsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 255);
                this.addRow(this.fddimibSMTMACCtsFieldLabel, (Component)numericInput);
                FddiStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.fddimibSMTMACCtsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getfddimibSMTMACCtsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTMACCtsField);
            this.validatefddimibSMTMACCtsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTMACCtsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTMACCtsField);
                jDMInput.setValue(object);
                this.validatefddimibSMTMACCtsField();
            }
        }

        protected boolean validatefddimibSMTMACCtsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTMACCtsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTMACCtsFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTMACCtsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTNonMasterCtsField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTNonMasterCts.access", "read-only");
            this.fddimibSMTNonMasterCtsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTNonMasterCtsFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTNonMasterCtsLabel"), 2);
            if (this.fddimibSMTNonMasterCtsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 2);
                this.addRow(this.fddimibSMTNonMasterCtsFieldLabel, (Component)numericInput);
                FddiStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.fddimibSMTNonMasterCtsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getfddimibSMTNonMasterCtsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTNonMasterCtsField);
            this.validatefddimibSMTNonMasterCtsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTNonMasterCtsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTNonMasterCtsField);
                jDMInput.setValue(object);
                this.validatefddimibSMTNonMasterCtsField();
            }
        }

        protected boolean validatefddimibSMTNonMasterCtsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTNonMasterCtsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTNonMasterCtsFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTNonMasterCtsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTConnectionPolicyField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTConnectionPolicy.access", "read-write");
            this.fddimibSMTConnectionPolicyFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTConnectionPolicyFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTConnectionPolicyLabel"), 2);
            if (this.fddimibSMTConnectionPolicyFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(32768, 65535);
                this.addRow(this.fddimibSMTConnectionPolicyFieldLabel, (Component)numericInput);
                FddiStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.fddimibSMTConnectionPolicyFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getfddimibSMTConnectionPolicyField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTConnectionPolicyField);
            this.validatefddimibSMTConnectionPolicyField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTConnectionPolicyField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTConnectionPolicyField);
                jDMInput.setValue(object);
                this.validatefddimibSMTConnectionPolicyField();
            }
        }

        protected boolean validatefddimibSMTConnectionPolicyField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTConnectionPolicyField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTConnectionPolicyFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTConnectionPolicyFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTTNotifyField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTTNotify.access", "read-write");
            this.fddimibSMTTNotifyFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTTNotifyFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTTNotifyLabel"), 2);
            if (this.fddimibSMTTNotifyFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(2, 30);
                this.addRow(this.fddimibSMTTNotifyFieldLabel, (Component)numericInput);
                FddiStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.fddimibSMTTNotifyFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getfddimibSMTTNotifyField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTTNotifyField);
            this.validatefddimibSMTTNotifyField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTTNotifyField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTTNotifyField);
                jDMInput.setValue(object);
                this.validatefddimibSMTTNotifyField();
            }
        }

        protected boolean validatefddimibSMTTNotifyField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTTNotifyField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTTNotifyFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTTNotifyFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTStatRptPolicyField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTStatRptPolicy.access", "read-write");
            this.fddimibSMTStatRptPolicyFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTStatRptPolicyFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTStatRptPolicyLabel"), 2);
            if (this.fddimibSMTStatRptPolicyFieldWritable) {
                BooleanInput booleanInput = new BooleanInput();
                this.addRow(this.fddimibSMTStatRptPolicyFieldLabel, (Component)booleanInput);
                FddiStationPanel.this.containsWritableField = true;
                return booleanInput;
            }
            BooleanInputRO booleanInputRO = new BooleanInputRO();
            this.addRow(this.fddimibSMTStatRptPolicyFieldLabel, (Component)booleanInputRO);
            return booleanInputRO;
        }

        protected Serializable getfddimibSMTStatRptPolicyField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStatRptPolicyField);
            this.validatefddimibSMTStatRptPolicyField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTStatRptPolicyField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStatRptPolicyField);
                jDMInput.setValue(object);
                this.validatefddimibSMTStatRptPolicyField();
            }
        }

        protected boolean validatefddimibSMTStatRptPolicyField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStatRptPolicyField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTStatRptPolicyFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTStatRptPolicyFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTTraceMaxExpirationField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTTraceMaxExpiration.access", "read-write");
            this.fddimibSMTTraceMaxExpirationFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTTraceMaxExpirationFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTTraceMaxExpirationLabel"), 2);
            if (this.fddimibSMTTraceMaxExpirationFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, Integer.MAX_VALUE);
                this.addRow(this.fddimibSMTTraceMaxExpirationFieldLabel, (Component)numericInput);
                FddiStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.fddimibSMTTraceMaxExpirationFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getfddimibSMTTraceMaxExpirationField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTTraceMaxExpirationField);
            this.validatefddimibSMTTraceMaxExpirationField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTTraceMaxExpirationField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTTraceMaxExpirationField);
                jDMInput.setValue(object);
                this.validatefddimibSMTTraceMaxExpirationField();
            }
        }

        protected boolean validatefddimibSMTTraceMaxExpirationField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTTraceMaxExpirationField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTTraceMaxExpirationFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTTraceMaxExpirationFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTBypassPresentField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTBypassPresent.access", "read-only");
            this.fddimibSMTBypassPresentFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTBypassPresentFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTBypassPresentLabel"), 2);
            if (this.fddimibSMTBypassPresentFieldWritable) {
                BooleanInput booleanInput = new BooleanInput();
                this.addRow(this.fddimibSMTBypassPresentFieldLabel, (Component)booleanInput);
                FddiStationPanel.this.containsWritableField = true;
                return booleanInput;
            }
            BooleanInputRO booleanInputRO = new BooleanInputRO();
            this.addRow(this.fddimibSMTBypassPresentFieldLabel, (Component)booleanInputRO);
            return booleanInputRO;
        }

        protected Serializable getfddimibSMTBypassPresentField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTBypassPresentField);
            this.validatefddimibSMTBypassPresentField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTBypassPresentField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTBypassPresentField);
                jDMInput.setValue(object);
                this.validatefddimibSMTBypassPresentField();
            }
        }

        protected boolean validatefddimibSMTBypassPresentField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTBypassPresentField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTBypassPresentFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTBypassPresentFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTECMStateField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTECMState.access", "read-only");
            this.fddimibSMTECMStateFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTECMStateFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTECMStateLabel"), 2);
            if (this.fddimibSMTECMStateFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(StationModel.Panel.FddimibSMTECMStateEnum.symbolicValues, StationModel.Panel.FddimibSMTECMStateEnum.numericValues, FddiStationPanel.getEnumStrings());
                this.addRow(this.fddimibSMTECMStateFieldLabel, (Component)singleChoiceInput);
                FddiStationPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(StationModel.Panel.FddimibSMTECMStateEnum.symbolicValues, StationModel.Panel.FddimibSMTECMStateEnum.numericValues, FddiStationPanel.getEnumStrings());
            this.addRow(this.fddimibSMTECMStateFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getfddimibSMTECMStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTECMStateField);
            this.validatefddimibSMTECMStateField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTECMStateField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTECMStateField);
                jDMInput.setValue(object);
                this.validatefddimibSMTECMStateField();
            }
        }

        protected boolean validatefddimibSMTECMStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTECMStateField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTECMStateFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTECMStateFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTCFStateField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTCFState.access", "read-only");
            this.fddimibSMTCFStateFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTCFStateFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTCFStateLabel"), 2);
            if (this.fddimibSMTCFStateFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(StationModel.Panel.FddimibSMTCFStateEnum.symbolicValues, StationModel.Panel.FddimibSMTCFStateEnum.numericValues, FddiStationPanel.getEnumStrings());
                this.addRow(this.fddimibSMTCFStateFieldLabel, (Component)singleChoiceInput);
                FddiStationPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(StationModel.Panel.FddimibSMTCFStateEnum.symbolicValues, StationModel.Panel.FddimibSMTCFStateEnum.numericValues, FddiStationPanel.getEnumStrings());
            this.addRow(this.fddimibSMTCFStateFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getfddimibSMTCFStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTCFStateField);
            this.validatefddimibSMTCFStateField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTCFStateField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTCFStateField);
                jDMInput.setValue(object);
                this.validatefddimibSMTCFStateField();
            }
        }

        protected boolean validatefddimibSMTCFStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTCFStateField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTCFStateFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTCFStateFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTRemoteDisconnectFlagField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTRemoteDisconnectFlag.access", "read-only");
            this.fddimibSMTRemoteDisconnectFlagFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTRemoteDisconnectFlagFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTRemoteDisconnectFlagLabel"), 2);
            if (this.fddimibSMTRemoteDisconnectFlagFieldWritable) {
                BooleanInput booleanInput = new BooleanInput();
                this.addRow(this.fddimibSMTRemoteDisconnectFlagFieldLabel, (Component)booleanInput);
                FddiStationPanel.this.containsWritableField = true;
                return booleanInput;
            }
            BooleanInputRO booleanInputRO = new BooleanInputRO();
            this.addRow(this.fddimibSMTRemoteDisconnectFlagFieldLabel, (Component)booleanInputRO);
            return booleanInputRO;
        }

        protected Serializable getfddimibSMTRemoteDisconnectFlagField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTRemoteDisconnectFlagField);
            this.validatefddimibSMTRemoteDisconnectFlagField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTRemoteDisconnectFlagField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTRemoteDisconnectFlagField);
                jDMInput.setValue(object);
                this.validatefddimibSMTRemoteDisconnectFlagField();
            }
        }

        protected boolean validatefddimibSMTRemoteDisconnectFlagField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTRemoteDisconnectFlagField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTRemoteDisconnectFlagFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTRemoteDisconnectFlagFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTStationStatusField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTStationStatus.access", "read-only");
            this.fddimibSMTStationStatusFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTStationStatusFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTStationStatusLabel"), 2);
            if (this.fddimibSMTStationStatusFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(StationModel.Panel.FddimibSMTStationStatusEnum.symbolicValues, StationModel.Panel.FddimibSMTStationStatusEnum.numericValues, FddiStationPanel.getEnumStrings());
                this.addRow(this.fddimibSMTStationStatusFieldLabel, (Component)singleChoiceInput);
                FddiStationPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(StationModel.Panel.FddimibSMTStationStatusEnum.symbolicValues, StationModel.Panel.FddimibSMTStationStatusEnum.numericValues, FddiStationPanel.getEnumStrings());
            this.addRow(this.fddimibSMTStationStatusFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getfddimibSMTStationStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStationStatusField);
            this.validatefddimibSMTStationStatusField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTStationStatusField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStationStatusField);
                jDMInput.setValue(object);
                this.validatefddimibSMTStationStatusField();
            }
        }

        protected boolean validatefddimibSMTStationStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStationStatusField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTStationStatusFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTStationStatusFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTPeerWrapFlagField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTPeerWrapFlag.access", "read-only");
            this.fddimibSMTPeerWrapFlagFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTPeerWrapFlagFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTPeerWrapFlagLabel"), 2);
            if (this.fddimibSMTPeerWrapFlagFieldWritable) {
                BooleanInput booleanInput = new BooleanInput();
                this.addRow(this.fddimibSMTPeerWrapFlagFieldLabel, (Component)booleanInput);
                FddiStationPanel.this.containsWritableField = true;
                return booleanInput;
            }
            BooleanInputRO booleanInputRO = new BooleanInputRO();
            this.addRow(this.fddimibSMTPeerWrapFlagFieldLabel, (Component)booleanInputRO);
            return booleanInputRO;
        }

        protected Serializable getfddimibSMTPeerWrapFlagField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTPeerWrapFlagField);
            this.validatefddimibSMTPeerWrapFlagField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTPeerWrapFlagField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTPeerWrapFlagField);
                jDMInput.setValue(object);
                this.validatefddimibSMTPeerWrapFlagField();
            }
        }

        protected boolean validatefddimibSMTPeerWrapFlagField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTPeerWrapFlagField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTPeerWrapFlagFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTPeerWrapFlagFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createfddimibSMTStationActionField() {
            String string = FddiStationPanel.this.getOverride("ibm.nways.fddi.model.Station.Panel.FddimibSMTStationAction.access", "read-write");
            this.fddimibSMTStationActionFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.fddimibSMTStationActionFieldLabel = new Label(FddiStationPanel.getNLSString("fddimibSMTStationActionLabel"), 2);
            if (this.fddimibSMTStationActionFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(StationModel.Panel.FddimibSMTStationActionEnum.symbolicValues, StationModel.Panel.FddimibSMTStationActionEnum.numericValues, FddiStationPanel.getEnumStrings());
                this.addRow(this.fddimibSMTStationActionFieldLabel, (Component)singleChoiceInput);
                FddiStationPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(StationModel.Panel.FddimibSMTStationActionEnum.symbolicValues, StationModel.Panel.FddimibSMTStationActionEnum.numericValues, FddiStationPanel.getEnumStrings());
            this.addRow(this.fddimibSMTStationActionFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getfddimibSMTStationActionField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStationActionField);
            this.validatefddimibSMTStationActionField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setfddimibSMTStationActionField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStationActionField);
                jDMInput.setValue(object);
                this.validatefddimibSMTStationActionField();
            }
        }

        protected boolean validatefddimibSMTStationActionField() {
            JDMInput jDMInput = (JDMInput)((Object)this.fddimibSMTStationActionField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.fddimibSMTStationActionFieldLabel.setForeground(Color.yellow);
            } else {
                this.fddimibSMTStationActionFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.fddimibSMTStationIdField = this.createfddimibSMTStationIdField();
            this.fddimibSMTUserDataField = this.createfddimibSMTUserDataField();
            this.fddimibSMTAvailablePathsField = this.createfddimibSMTAvailablePathsField();
            this.fddimibSMTConfigCapabilitiesField = this.createfddimibSMTConfigCapabilitiesField();
            this.fddimibSMTConfigPolicyField = this.createfddimibSMTConfigPolicyField();
            this.fddimibSMTMACCtsField = this.createfddimibSMTMACCtsField();
            this.fddimibSMTNonMasterCtsField = this.createfddimibSMTNonMasterCtsField();
            this.fddimibSMTConnectionPolicyField = this.createfddimibSMTConnectionPolicyField();
            this.fddimibSMTTNotifyField = this.createfddimibSMTTNotifyField();
            this.fddimibSMTStatRptPolicyField = this.createfddimibSMTStatRptPolicyField();
            this.fddimibSMTTraceMaxExpirationField = this.createfddimibSMTTraceMaxExpirationField();
            this.fddimibSMTBypassPresentField = this.createfddimibSMTBypassPresentField();
            this.fddimibSMTECMStateField = this.createfddimibSMTECMStateField();
            this.fddimibSMTCFStateField = this.createfddimibSMTCFStateField();
            this.fddimibSMTRemoteDisconnectFlagField = this.createfddimibSMTRemoteDisconnectFlagField();
            this.fddimibSMTStationStatusField = this.createfddimibSMTStationStatusField();
            this.fddimibSMTPeerWrapFlagField = this.createfddimibSMTPeerWrapFlagField();
            this.fddimibSMTStationActionField = this.createfddimibSMTStationActionField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.fddimibSMTStationIdField)).ignoreValue() && this.fddimibSMTStationIdFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTStationId", this.getfddimibSMTStationIdField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTUserDataField)).ignoreValue() && this.fddimibSMTUserDataFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTUserData", this.getfddimibSMTUserDataField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTAvailablePathsField)).ignoreValue() && this.fddimibSMTAvailablePathsFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTAvailablePaths", this.getfddimibSMTAvailablePathsField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTConfigCapabilitiesField)).ignoreValue() && this.fddimibSMTConfigCapabilitiesFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTConfigCapabilities", this.getfddimibSMTConfigCapabilitiesField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTConfigPolicyField)).ignoreValue() && this.fddimibSMTConfigPolicyFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTConfigPolicy", this.getfddimibSMTConfigPolicyField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTMACCtsField)).ignoreValue() && this.fddimibSMTMACCtsFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTMACCts", this.getfddimibSMTMACCtsField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTNonMasterCtsField)).ignoreValue() && this.fddimibSMTNonMasterCtsFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTNonMasterCts", this.getfddimibSMTNonMasterCtsField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTConnectionPolicyField)).ignoreValue() && this.fddimibSMTConnectionPolicyFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTConnectionPolicy", this.getfddimibSMTConnectionPolicyField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTTNotifyField)).ignoreValue() && this.fddimibSMTTNotifyFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTTNotify", this.getfddimibSMTTNotifyField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTStatRptPolicyField)).ignoreValue() && this.fddimibSMTStatRptPolicyFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTStatRptPolicy", this.getfddimibSMTStatRptPolicyField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTTraceMaxExpirationField)).ignoreValue() && this.fddimibSMTTraceMaxExpirationFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTTraceMaxExpiration", this.getfddimibSMTTraceMaxExpirationField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTBypassPresentField)).ignoreValue() && this.fddimibSMTBypassPresentFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTBypassPresent", this.getfddimibSMTBypassPresentField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTECMStateField)).ignoreValue() && this.fddimibSMTECMStateFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTECMState", this.getfddimibSMTECMStateField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTCFStateField)).ignoreValue() && this.fddimibSMTCFStateFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTCFState", this.getfddimibSMTCFStateField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTRemoteDisconnectFlagField)).ignoreValue() && this.fddimibSMTRemoteDisconnectFlagFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTRemoteDisconnectFlag", this.getfddimibSMTRemoteDisconnectFlagField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTStationStatusField)).ignoreValue() && this.fddimibSMTStationStatusFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTStationStatus", this.getfddimibSMTStationStatusField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTPeerWrapFlagField)).ignoreValue() && this.fddimibSMTPeerWrapFlagFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTPeerWrapFlag", this.getfddimibSMTPeerWrapFlagField());
                }
                if (!((JDMInput)((Object)this.fddimibSMTStationActionField)).ignoreValue() && this.fddimibSMTStationActionFieldWritable) {
                    FddiStationPanel.this.PanelInfo.add("Panel.FddimibSMTStationAction", this.getfddimibSMTStationActionField());
                    return;
                }
            } else {
                FddiStationPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            FddiStationPanel.this.displayMsg(FddiStationPanel.getNLSString("accessDataMsg"));
            try {
                this.setfddimibSMTStationIdField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTStationId", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTUserDataField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTUserData", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTAvailablePathsField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTAvailablePaths", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTConfigCapabilitiesField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTConfigCapabilities", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTConfigPolicyField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTConfigPolicy", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTMACCtsField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTMACCts", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTNonMasterCtsField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTNonMasterCts", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTConnectionPolicyField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTConnectionPolicy", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTTNotifyField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTTNotify", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTStatRptPolicyField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTStatRptPolicy", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTTraceMaxExpirationField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTTraceMaxExpiration", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTBypassPresentField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTBypassPresent", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTECMStateField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTECMState", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTCFStateField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTCFState", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTRemoteDisconnectFlagField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTRemoteDisconnectFlag", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTStationStatusField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTStationStatus", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTPeerWrapFlagField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTPeerWrapFlag", FddiStationPanel.this.FddimibSMTTableIndex));
                this.setfddimibSMTStationActionField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTStationAction", FddiStationPanel.this.FddimibSMTTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            FddiStationPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setfddimibSMTStationIdField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTStationId", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTUserDataField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTUserData", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTAvailablePathsField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTAvailablePaths", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTConfigCapabilitiesField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTConfigCapabilities", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTConfigPolicyField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTConfigPolicy", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTMACCtsField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTMACCts", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTNonMasterCtsField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTNonMasterCts", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTConnectionPolicyField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTConnectionPolicy", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTTNotifyField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTTNotify", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTStatRptPolicyField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTStatRptPolicy", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTTraceMaxExpirationField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTTraceMaxExpiration", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTBypassPresentField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTBypassPresent", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTECMStateField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTECMState", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTCFStateField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTCFState", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTRemoteDisconnectFlagField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTRemoteDisconnectFlag", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTStationStatusField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTStationStatus", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTPeerWrapFlagField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTPeerWrapFlag", FddiStationPanel.this.FddimibSMTTableIndex));
            this.setfddimibSMTStationActionField(FddiStationPanel.this.FddimibSMTTableData.getValueAt("Panel.FddimibSMTStationAction", FddiStationPanel.this.FddimibSMTTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.fddimibSMTTraceMaxExpirationField)).ignoreValue() && !this.validatefddimibSMTTraceMaxExpirationField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.fddimibSMTStatRptPolicyField)).ignoreValue() && !this.validatefddimibSMTStatRptPolicyField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.fddimibSMTConnectionPolicyField)).ignoreValue() && !this.validatefddimibSMTConnectionPolicyField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.fddimibSMTTNotifyField)).ignoreValue() && !this.validatefddimibSMTTNotifyField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.fddimibSMTStationActionField)).ignoreValue() && !this.validatefddimibSMTStationActionField()) {
                return false;
            }
            return ((JDMInput)((Object)this.fddimibSMTConfigPolicyField)).ignoreValue() || this.validatefddimibSMTConfigPolicyField();
        }
    }

    public class FddimibSMTTable
    extends Table {
        public ModelInfo setRow() {
            try {
                FddiStationPanel.this.displayMsg(FddiStationPanel.getNLSString("startSendMsg"));
                FddiStationPanel.this.PanelInfo = FddiStationPanel.this.Station_model.setInfo("Panel", FddiStationPanel.this.PanelInfo);
                FddiStationPanel.this.displayMsg(FddiStationPanel.getNLSString("endSendMsg"));
                if (FddiStationPanel.this.PanelInfo != null) {
                    Enumeration enumeration = FddiStationPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = FddiStationPanel.this.PanelInfo.get(string);
                        FddiStationPanel.this.FddimibSMTTableInfo.add(string, serializable);
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return FddiStationPanel.this.FddimibSMTTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    FddiStationPanel.this.FddimibSMTTableInfo = null;
                    FddiStationPanel.this.displayMsg(FddiStationPanel.getNLSString("startRow"));
                    FddiStationPanel.this.PanelInfo = FddiStationPanel.this.Station_model.getNextInfo("Panel", "default", modelInfo);
                    FddiStationPanel.this.displayMsg(FddiStationPanel.getNLSString("endRow"));
                    if (FddiStationPanel.this.PanelInfo != null) {
                        FddiStationPanel.this.FddimibSMTTableInfo = new ModelInfo();
                        if (FddiStationPanel.this.PanelInfo.isBeingMonitored()) {
                            FddiStationPanel.this.FddimibSMTTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = FddiStationPanel.this.PanelInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = FddiStationPanel.this.PanelInfo.get(string);
                            FddiStationPanel.this.FddimibSMTTableInfo.add(string, serializable);
                        }
                    }
                    if (FddiStationPanel.this.FddimibSMTTableInfo != null && !this.validRow(FddiStationPanel.this.FddimibSMTTableInfo)) {
                        modelInfo = FddiStationPanel.this.FddimibSMTTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return FddiStationPanel.this.FddimibSMTTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            FddiStationPanel.this.FddimibSMTTableInfo = null;
            try {
                FddiStationPanel.this.displayMsg(FddiStationPanel.getNLSString("startRow"));
                FddiStationPanel.this.PanelInfo = FddiStationPanel.this.Station_model.getInfo("Panel", "default", modelInfo);
                FddiStationPanel.this.displayMsg(FddiStationPanel.getNLSString("endRow"));
                if (FddiStationPanel.this.PanelInfo != null) {
                    FddiStationPanel.this.FddimibSMTTableInfo = new ModelInfo();
                    if (FddiStationPanel.this.PanelInfo.isBeingMonitored()) {
                        FddiStationPanel.this.FddimibSMTTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = FddiStationPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = FddiStationPanel.this.PanelInfo.get(string);
                        FddiStationPanel.this.FddimibSMTTableInfo.add(string, serializable);
                    }
                }
                if (FddiStationPanel.this.FddimibSMTTableInfo != null && !this.validRow(FddiStationPanel.this.FddimibSMTTableInfo)) {
                    FddiStationPanel.this.FddimibSMTTableInfo = this.getRow(FddiStationPanel.this.FddimibSMTTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return FddiStationPanel.this.FddimibSMTTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (FddiStationPanel.this.FddimibSMTTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            FddiStationPanel.this.FddimibSMTTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        FddiStationPanel.this.FddimibSMTTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        FddiStationPanel.this.FddimibSMTTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    FddiStationPanel.this.FddimibSMTTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            try {
                if (string.equals("Panel.FddimibSMTCFState")) {
                    string2 = enumStrings.getString(StationModel.Panel.FddimibSMTCFStateEnum.numericToSymbolic(n));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            return string2;
        }

        public FddimibSMTTable() {
            FddiStationPanel.this = FddiStationPanel.this;
        }
    }
}

